#define dex_add_zdirection
global.zdirection+=argument0;
#define dex_billboard_draw
 {
   d3d_transform_set_identity();
   d3d_transform_add_rotation_x(90);
   d3d_transform_add_rotation_z(point_direction(x,y,argument0.x,argument0.y)+90);
   d3d_transform_add_translation(x,y,argument1);
   draw_sprite_ext(argument2,argument3,0,0,1,1,0,c_white,1);
   d3d_transform_set_identity()
 }
#define dex_define_fog
 {
   d3d_set_fog(argument0,argument1,argument2,argument3);
 }
#define dex_define_lighting
 {
    d3d_set_lighting(argument0);
 }
#define dex_define_texture_interpolation
 {
   texture_set_interpolation(argument0);
 }
#define dex_draw_block
 {
   d3d_draw_block(argument0,argument1,argument2,argument3,argument4,argument5,sprite_get_texture(argument6,0),1,1);
 }
#define dex_draw_cone
 {
   d3d_draw_cone(argument0,argument1,argument2,argument3,argument4,argument5,sprite_get_texture(argument6,0),1,1,true,50);
 }
#define dex_draw_cylinder
 {
   d3d_draw_cylinder(argument0,argument1,argument2,argument3,argument4,argument5,sprite_get_texture(argument6,0),1,1,true,50);
 }
#define dex_draw_ellipsoid
 {
   d3d_draw_ellipsoid(argument0,argument1,argument2,argument3,argument4,argument5,sprite_get_texture(argument6,0),1,1,50);
 }
#define dex_draw_flashlight
 {
   global.xx = 0;
   global.yy = 0;
   global.xt = -9+random(18);
   global.yt = -9+random(18);
   global.dir = point_direction(global.xx,global.yy,global.xt,global.yt)
   global.xx += lengthdir_x(.1,global.dir);
   global.yy += lengthdir_y(.1,global.dir);
   if (point_distance(global.xx,global.yy,global.xt,global.yt)<=1)
    {
   global.xt = -9+random(18);
   global.yt = -9+random(18);
    }
   d3d_set_projection_ortho(0,0,view_wview,view_hview,0);
   draw_set_blend_mode_ext(9,3);
   draw_sprite_ext(argument0,0,view_wview/2+global.xx,view_hview/2+global.yy,1,1,0,c_white,1);
   draw_set_blend_mode(bm_normal);
 }
#define dex_draw_floor
 {
   d3d_draw_floor(argument0,argument1,argument2,argument3,argument4,argument5,sprite_get_texture(argument6,0),1,1);
 }
#define dex_draw_overlay
 {
   d3d_set_projection_ortho(0,0,view_wview,view_hview,0);
 }
#define dex_draw_skybox
 {
   size=argument0
   d3d_draw_block(x-size,y-size,argument1-size,x+size,y+size,argument1+size,sprite_get_texture(argument2,argument3),1,1);
 }
#define dex_draw_skydome
 {
   size=argument0
   d3d_draw_ellipsoid(x-size,y-size,argument1-size,x+size,y+size,argument1+size,sprite_get_texture(argument2,argument3),1,1,50);
 }
#define dex_draw_wall
 {
   d3d_draw_wall(argument0,argument1,argument2,argument3,argument4,argument5,sprite_get_texture(argument6,0),1,1);
 }
#define dex_draw_water
 {
   global.offset+=.1
   if global.offset>=12
    {
      global.offset=0
    }
   draw_set_blend_mode(bm_add)
   d3d_draw_floor(-2400+global.offset,-2400+global.offset,argument0,2400,2400,argument0,sprite_get_texture(argument1,0),400,400)
   draw_set_blend_mode(bm_normal)
 }
#define dex_dump
{
  d3d_end();
}
#define dex_extmodel_load
modelload[0]=0;
modelload[1]=0;

var flipnormals,fliptex,cur_milisec;
flipnormals=1;
if(argument2)flipnormals=-1;
fliptex=argument3;
scale=argument4;
cur_milisec=current_time;
modelload[0]=0;

if(string_count(".mod",argument1)>0)d3d_model_load(argument0,argument1);

if(string_count(".vtx",argument1)>0) 
    {
    var str,file,row,data,i,tex_y,temp,t;
    file=file_text_open_read(argument1);
    data=ds_list_create();
    row=""
    do
        {
        if!(string_count(".Vertex",row)=1)
            {
            do {row=file_text_read_string(file);file_text_readln(file)}
            until string_count(".Vertex",row)=1
            }
    
        do
            {
            row=file_text_read_string(file);file_text_readln(file)
            if(string_count("// end of .Vertex",row)=0)
                {
                str=string_copy(row,1,string_pos(" ",row)-1);
                row=string_delete(row,1,string_pos(" ",row)-1);
                ds_list_add(data,real(str));
                repeat((3-1)+3+(2-1))
                    {
                    row=string_delete(row,1,1);
                    str=string_copy(row,1,string_pos(" ",row)-1);
                    row=string_delete(row,1,string_pos(" ",row)-1);
                    ds_list_add(data,real(str));
                    }
                row=string_delete(row,1,1)
                str=string_copy(row,1,string_length(row))
                ds_list_add(data,real(str))
                }
            }
        until string_count("// end of .Vertex",row)=1

        do {row=file_text_read_string(file);file_text_readln(file)}
        until string_count(".Index",row)=1

        do
            {
            d3d_model_primitive_begin(argument0,pr_trianglelist)
            
            row=file_text_read_string(file);file_text_readln(file)
            
            if(string_count("// end if .Index",row)=0)
                {
                t=0
                repeat(3)
                    {
                    str=string_copy(row,1,string_pos(" ",row)-1)
                    row=string_delete(row,1,string_pos(" ",row))
                    temp[t]=real(str)
                    t+=1
                    }
                t=2
                repeat(3)
                    {
                    i=temp[t]*8
                    tex_y=ds_list_find_value(data,i+7)
                    if(fliptex)tex_y=1-tex_y
                    
                    d3d_model_vertex_normal_texture(argument0,ds_list_find_value(data,i+0)*scale,ds_list_find_value(data,i+1)*scale,ds_list_find_value(data,i+2)*scale
                                                            ,flipnormals*ds_list_find_value(data,i+3),flipnormals*ds_list_find_value(data,i+4),flipnormals*ds_list_find_value(data,i+5)
                                                            ,ds_list_find_value(data,i+6),tex_y);modelload[0]+=1;
                    t-=1
                    }
                d3d_model_primitive_end(argument0)
                d3d_model_primitive_begin(argument0,pr_trianglelist)
                }
            }
        until string_count("// end if .Index",row)=1

        d3d_model_primitive_end(argument0)
        ds_list_clear(data);
    
        do {row=file_text_read_string(file);file_text_readln(file)}
        until string_count("// end of .Brdf",row)=1
        do {row=file_text_read_string(file);file_text_readln(file)}
        until string_count(".Vertex",row)=1||string_count("// End of file",row)=1
        }
    until string_count("// End of file",row)=1||file_text_eof(file)
    file_text_close(file);
    ds_list_destroy(data);
    }
    
if(string_count(".obj",argument1)>0) 
    {
    var str,file,row,tex_y,v_x,v_y,v_z,n_x,n_y,n_z,u,v,i,numb,edges,faces,t,p_count;
    file=file_text_open_read(argument1);
    v_x=ds_list_create();ds_list_add(v_x,0);
    v_y=ds_list_create();ds_list_add(v_y,0);
    v_z=ds_list_create();ds_list_add(v_z,0);
    n_x=ds_list_create();ds_list_add(n_x,0);
    n_y=ds_list_create();ds_list_add(n_y,0);
    n_z=ds_list_create();ds_list_add(n_z,0);
    u=ds_list_create();ds_list_add(u,0);
    v=ds_list_create();ds_list_add(v,0);
    row=""
    
    do
        {
        if(string_count("v ",row)=0)
           {
           do {row=file_text_read_string(file);file_text_readln(file)}
           until string_char_at(row,1)="v"&&string_char_at(row,2)=" "
           }
    
        do 
            {
            row=string_delete(row,1,string_pos(" ",row));
            str=string_copy(row,1,string_pos(" ",row)-1); 
            row=string_delete(row,1,string_pos(" ",row));
            ds_list_add(v_x,real(str));
            str=string_copy(row,1,string_pos(" ",row)-1) 
            row=string_delete(row,1,string_pos(" ",row));
            ds_list_add(v_y,real(str));
            str=string_copy(row,1,string_length(row)) 
            ds_list_add(v_z,real(str));
            row=file_text_read_string(file);file_text_readln(file)
            }
        until string_count("v ",row)=0
        
        do {row=file_text_read_string(file);file_text_readln(file)}
        until (string_char_at(row,1)="v"&&string_char_at(row,2)="n")||(string_char_at(row,1)="v"&&string_char_at(row,2)="t")||(string_char_at(row,1)="f"&&string_char_at(row,2)=" ")

        if(string_count("vn ",row)=1)
            {
            do 
                {
                row=string_delete(row,1,string_pos(" ",row));
                str=string_copy(row,1,string_pos(" ",row)-1); 
                row=string_delete(row,1,string_pos(" ",row));
                ds_list_add(n_x,real(str));
                str=string_copy(row,1,string_pos(" ",row)-1) 
                row=string_delete(row,1,string_pos(" ",row));
                ds_list_add(n_y,real(str));
                str=string_copy(row,1,string_length(row)) 
                ds_list_add(n_z,real(str)); 
                row=file_text_read_string(file);file_text_readln(file) 
                }
            until string_count("vn ",row)=0
            }
                
        if(string_count("vt ",row)=0)
           {
            do {row=file_text_read_string(file);file_text_readln(file)}
            until (string_char_at(row,1)="v"&&string_char_at(row,2)="t")||(string_char_at(row,1)="f"&&string_char_at(row,2)=" ")
            }
        
        if(string_count("vt ",row)=1)
            {
            do 
                {
                row=string_delete(row,1,string_pos(" ",row));
                str=string_copy(row,1,string_pos(" ",row)-1); 
                row=string_delete(row,1,string_pos(" ",row));
                ds_list_add(u,real(str));
                str=string_copy(row,1,string_length(row)) 
                ds_list_add(v,real(str));
                row=file_text_read_string(file);file_text_readln(file) 
                }
            until string_count("vt ",row)=0
            }
        if(string_count("f ",row)=0)
           {
           do {row=file_text_read_string(file);file_text_readln(file)}
           until (string_char_at(row,1)="f"&&string_char_at(row,2)=" ")
           }
 
  
        pos=0
        do
            {
            d3d_model_primitive_begin(argument0,pr_trianglelist)
            
            row=string_delete(row,1,string_pos(" ",row));
            row=string_replace_all(row,"//","/0/");
            
            str=string_copy(row,1,string_pos(" ",row)-1); 
            p_count=string_count("/",str)
            if(p_count!=2)row=string_replace_all(row," ","/0 ");
            
            if(string_char_at(row,string_length(row))=" ")row=string_copy(row,1,string_length(row)-1)
            
            edges=string_count(" ",row)+1
            for(t=0;t<edges;t+=1)
                {
                str=string_copy(row,1,string_pos("/",row)-1); 
                row=string_delete(row,1,string_pos("/",row));
                faces[t,0]=real(str);

                str=string_copy(row,1,string_pos("/",row)-1); 
                row=string_delete(row,1,string_pos("/",row));
                faces[t,1]=real(str);

            if!(t=edges-1)
                {
                str=string_copy(row,1,string_pos(" ",row)-1); 
                row=string_delete(row,1,string_pos(" ",row));
                }
                else str=string_copy(row,1,string_length(row)); 
            faces[t,2]=real(str);
            }
            if(edges<=3)
                {
                for(t=0;t<edges;t+=1)
                    {
                    tex_y=ds_list_find_value(v,faces[t,1])
                    if(fliptex)tex_y=1-tex_y
                    d3d_model_vertex_normal_texture(argument0,ds_list_find_value(v_x,faces[t,0])*scale,ds_list_find_value(v_y,faces[t,0])*scale,ds_list_find_value(v_z,faces[t,0])*scale
                                                         ,flipnormals*ds_list_find_value(n_x,faces[t,2]),flipnormals*ds_list_find_value(n_y,faces[t,2]),flipnormals*ds_list_find_value(n_z,faces[t,2])
                                                         ,ds_list_find_value(u,faces[t,1]),tex_y);modelload[0]+=1;
                    }
                }
            else
                {

                for(t=2;t<edges;t+=1)
                    {
                    tex_y=ds_list_find_value(v,faces[0,1])
                    if(fliptex)tex_y=1-tex_y
                    d3d_model_vertex_normal_texture(argument0,ds_list_find_value(v_x,faces[0,0])*scale,ds_list_find_value(v_y,faces[0,0])*scale,ds_list_find_value(v_z,faces[0,0])*scale,flipnormals*ds_list_find_value(n_x,faces[0,2]),flipnormals*ds_list_find_value(n_y,faces[0,2]),flipnormals*ds_list_find_value(n_z,faces[0,2]),ds_list_find_value(u,faces[0,1]),tex_y);modelload[0]+=1;
                    tex_y=ds_list_find_value(v,faces[t-1,1])
                    if(fliptex)tex_y=1-tex_y
                    d3d_model_vertex_normal_texture(argument0,ds_list_find_value(v_x,faces[t-1,0])*scale,ds_list_find_value(v_y,faces[t-1,0])*scale,ds_list_find_value(v_z,faces[t-1,0])*scale,flipnormals*ds_list_find_value(n_x,faces[t-1,2]),flipnormals*ds_list_find_value(n_y,faces[t-1,2]),flipnormals*ds_list_find_value(n_z,faces[t-1,2]),ds_list_find_value(u,faces[t-1,1]),tex_y);modelload[0]+=1;
                    tex_y=ds_list_find_value(v,faces[t,1])
                    if(fliptex)tex_y=1-tex_y
                    d3d_model_vertex_normal_texture(argument0,ds_list_find_value(v_x,faces[t,0])*scale,ds_list_find_value(v_y,faces[t,0])*scale,ds_list_find_value(v_z,faces[t,0])*scale,flipnormals*ds_list_find_value(n_x,faces[t,2]),flipnormals*ds_list_find_value(n_y,faces[t,2]),flipnormals*ds_list_find_value(n_z,faces[t,2]),ds_list_find_value(u,faces[t,1]),tex_y);modelload[0]+=1;
                    }
                }
            d3d_model_primitive_end(argument0)
            d3d_model_primitive_begin(argument0,pr_trianglelist)   

            row=file_text_read_string(file);file_text_readln(file)
            if(string_count("f ",row)=0)
                {
                do {row=file_text_read_string(file);file_text_readln(file)}
                until (string_char_at(row,1)="f"&&string_char_at(row,2)=" ")||(string_char_at(row,1)="v"&&string_char_at(row,2)=" ")||file_text_eof(file);
                }
            }
        until string_count("f ",row)=0 
        
        d3d_model_primitive_end(argument0)
        while !(string_count("v ",row)=1||file_text_eof(file)) {row=file_text_read_string(file);file_text_readln(file)}
        }
    until file_text_eof(file);
           
    file_text_close(file);
    ds_list_destroy(v_x);ds_list_destroy(v_y);ds_list_destroy(v_z);
    ds_list_destroy(n_x);ds_list_destroy(n_y);ds_list_destroy(n_z);
    ds_list_destroy(u);ds_list_destroy(v);
    }

if(string_count(".x",argument1)>0) 
    {
    var str,file,row,tex_y,v_x,v_y,v_z,n_x,n_y,n_z,u,v,i,numb_faces,edges,faces,t,p_count;
    file=file_text_open_read(argument1);
    v_x=ds_list_create();
    v_y=ds_list_create();
    v_z=ds_list_create();    
    n_x=ds_list_create();
    n_y=ds_list_create();
    n_z=ds_list_create();
    u=ds_list_create();
    v=ds_list_create();
    row=""
    
    do
        {
        if!(string_count("Mesh {",row)=1)
            {
            do {row=file_text_read_string(file);file_text_readln(file)}
            until string_count("Mesh {",row)=1
            }
        row=file_text_read_string(file);file_text_readln(file); 
        do
            {
            row=file_text_read_string(file);file_text_readln(file)

                row=string_replace_all(row," ","")
            
                str=string_copy(row,1,string_pos(";",row)-1)
                row=string_delete(row,1,string_pos(";",row))
                ds_list_add(v_x,real(str))
                str=string_copy(row,1,string_pos(";",row)-1)
                row=string_delete(row,1,string_pos(";",row))
                ds_list_add(v_y,real(str))
                str=string_copy(row,1,string_pos(";",row)-1)
                row=string_delete(row,1,string_pos(";",row))
                ds_list_add(v_z,real(str))
                

            }
        until string_count(";",row)=1
        
        row=file_text_read_string(file);file_text_readln(file);
        numb_faces=real(string_digits(row))
        t=0
        do
            {
            row2=file_text_read_string(file);file_text_readln(file)

                row=string_replace_all(row2," ","")
                row=string_replace_all(row,";;",",;;")
                
                str=string_copy(row,1,string_pos(";",row)-1)
                row=string_delete(row,1,string_pos(";",row))
                faces[t,0]=real(str)
                for(i=1;i<=faces[t,0];i+=1)
                    {
                    str=string_copy(row,1,string_pos(",",row)-1)
                    row=string_delete(row,1,string_pos(",",row))
                    faces[t,i]=real(string_digits(str))
                    }
                t+=1
            }        
        until string_count(";;",row2)=1  
                   
        do {row=file_text_read_string(file);file_text_readln(file)}
        until string_count("MeshNormals {",row)=1
        
        row=file_text_read_string(file);file_text_readln(file);
        
        do
            {
            row=file_text_read_string(file);file_text_readln(file)
                row=string_replace_all(row," ","")
            
                str=string_copy(row,1,string_pos(";",row)-1)
                row=string_delete(row,1,string_pos(";",row))
                ds_list_add(n_x,real(str))
                str=string_copy(row,1,string_pos(";",row)-1)
                row=string_delete(row,1,string_pos(";",row))
                ds_list_add(n_y,real(str))
                str=string_copy(row,1,string_pos(";",row)-1)
                row=string_delete(row,1,string_pos(";",row))
                ds_list_add(n_z,real(str))

            }
        until string_count(";",row)=1

        do {row=file_text_read_string(file);file_text_readln(file)}
        until string_count("MeshTextureCoords {",row)=1
        
        row=file_text_read_string(file);file_text_readln(file);
        
        do
            {
            row=file_text_read_string(file);file_text_readln(file)

                row=string_replace_all(row," ","")
            
                str=string_copy(row,1,string_pos(";",row)-1)
                row=string_delete(row,1,string_pos(";",row))
                ds_list_add(u,real(str))
                str=string_copy(row,1,string_pos(";",row)-1)
                row=string_delete(row,1,string_pos(";",row))
                ds_list_add(v,real(str))

            }
        until string_count(";",row)=1
        
        for(i=0;i<numb_faces;i+=1)
            {
            d3d_model_primitive_begin(argument0,pr_trianglelist)
            t=1
            for(t=1;t<=faces[i,0];t+=1)
                {
                tex_y=ds_list_find_value(v,faces[i,t])
                if(fliptex)tex_y=1-tex_y
                d3d_model_vertex_normal_texture(argument0,ds_list_find_value(v_x,faces[i,t])*scale,ds_list_find_value(v_y,faces[i,t])*scale,ds_list_find_value(v_z,faces[i,t])*scale
                                                        ,flipnormals*ds_list_find_value(n_x,faces[i,t]),flipnormals*ds_list_find_value(n_y,faces[i,t]),flipnormals*ds_list_find_value(n_z,faces[i,t])
                                                        ,ds_list_find_value(u,faces[i,t]),tex_y);modelload[0]+=1;
                }
            d3d_model_primitive_end(argument0)      
            }
        
        do {row=file_text_read_string(file);file_text_readln(file)}
        until string_count("Mesh {",row)=1||file_text_eof(file)
    
        ds_list_clear(v_x);ds_list_clear(v_y);ds_list_clear(v_z);
        ds_list_clear(n_x);ds_list_clear(n_y);ds_list_clear(n_z);
        ds_list_clear(u);ds_list_clear(v);
        }
    until file_text_eof(file)

    
    file_text_close(file);
    ds_list_destroy(v_x);ds_list_destroy(v_y);ds_list_destroy(v_z);
    ds_list_destroy(n_x);ds_list_destroy(n_y);ds_list_destroy(n_z);
    ds_list_destroy(u);ds_list_destroy(v);
    }
    
if(string_count(".c",argument1)>0) 
    {
    var str,file,row,tex_y,v_x,v_y,v_z,n_x,n_y,n_z,u,v,i,numb,edges,faces,t,p_count;
    file=file_text_open_read(argument1);
    v_x=ds_list_create();
    v_y=ds_list_create();
    v_z=ds_list_create();    
    n_x=ds_list_create();
    n_y=ds_list_create();
    n_z=ds_list_create();
    u=ds_list_create();
    v=ds_list_create();
    row=""
    
    do
        {
        if!(string_count("_coords[]",row)=1)
            {
            do {row=file_text_read_string(file);file_text_readln(file)}
            until string_count("_coords[]",row)=1
            }
        do
            {
            row=file_text_read_string(file);file_text_readln(file)
            if(string_count("};",row)=0)
                {
                row=string_replace_all(row," ","")
            
                str=string_copy(row,1,string_pos(",",row)-1)
                row=string_delete(row,1,string_pos(",",row))
                ds_list_add(v_x,real(str))
                str=string_copy(row,1,string_pos(",",row)-1)
                row=string_delete(row,1,string_pos(",",row))
                ds_list_add(v_y,real(str))
                str=string_copy(row,1,string_pos(",",row)-1)
                row=string_delete(row,1,string_pos(",",row))
                ds_list_add(v_z,real(str))
                }
            }
        until string_count("};",row)=1
    
        do {row=file_text_read_string(file);file_text_readln(file)}
        until string_count("_normals[]",row)=1
    
        do
            {
            row=file_text_read_string(file);file_text_readln(file)
            if(string_count("};",row)=0)
                {
                row=string_replace_all(row," ","")
            
                str=string_copy(row,1,string_pos(",",row)-1)
                row=string_delete(row,1,string_pos(",",row))
                ds_list_add(n_x,real(str))
                str=string_copy(row,1,string_pos(",",row)-1)
                row=string_delete(row,1,string_pos(",",row))
                ds_list_add(n_y,real(str))
                str=string_copy(row,1,string_pos(",",row)-1)
                row=string_delete(row,1,string_pos(",",row))
                ds_list_add(n_z,real(str))
                }
            }
        until string_count("};",row)=1
    
        do {row=file_text_read_string(file);file_text_readln(file)}
        until string_count("_texcoords[]",row)=1
    
        do
            {
            row=file_text_read_string(file);file_text_readln(file)
            if(string_count("};",row)=0)
                {
                row=string_replace_all(row," ","")
            
                str=string_copy(row,1,string_pos(",",row)-1)
                row=string_delete(row,1,string_pos(",",row))
                ds_list_add(u,real(str))
                str=string_copy(row,1,string_pos(",",row)-1)
                row=string_delete(row,1,string_pos(",",row))
                ds_list_add(v,real(str))
                }
            }
        until string_count("};",row)=1
 
        do {row=file_text_read_string(file);file_text_readln(file)}
        until string_count("_indices[]",row)=1
    
        do
            {
            d3d_model_primitive_begin(argument0,pr_trianglelist)
            row=file_text_read_string(file);file_text_readln(file)
            if(string_count("};",row)=0)
                {
                row=string_replace_all(row," ","")
            
                str=string_copy(row,1,string_pos(",",row)-1)
                row=string_delete(row,1,string_pos(",",row))
                faces[0]=real(str)
                str=string_copy(row,1,string_pos(",",row)-1)
                row=string_delete(row,1,string_pos(",",row))
                faces[1]=real(str)
                str=string_copy(row,1,string_pos(",",row)-1)
                row=string_delete(row,1,string_pos(",",row))
                faces[2]=real(str)
                i=0
                repeat(3)
                    {
                    tex_y=ds_list_find_value(v,faces[i])
                    if(fliptex)tex_y=1-tex_y
                    d3d_model_vertex_normal_texture(argument0,ds_list_find_value(v_x,faces[i])*scale,ds_list_find_value(v_y,faces[i])*scale,ds_list_find_value(v_z,faces[i])*scale
                                                            ,flipnormals*ds_list_find_value(n_x,faces[i]),flipnormals*ds_list_find_value(n_y,faces[i]),flipnormals*ds_list_find_value(n_z,faces[i])
                                                            ,ds_list_find_value(u,faces[i]),tex_y);modelload[0]+=1;
                    i+=1    
                    }
                }
            d3d_model_primitive_end(argument0)
            }
        until string_count("};",row)=1
    
        do {row=file_text_read_string(file);file_text_readln(file)}
        until string_count("_coords[]",row)=1||string_count("// End of file",row)=1
    
        ds_list_clear(v_x);ds_list_clear(v_y);ds_list_clear(v_z);
        ds_list_clear(n_x);ds_list_clear(n_y);ds_list_clear(n_z);
        ds_list_clear(u);ds_list_clear(v);
        }
    until string_count("// End of file",row)=1||file_text_eof(file)

    
    file_text_close(file);
    ds_list_destroy(v_x);ds_list_destroy(v_y);ds_list_destroy(v_z);
    ds_list_destroy(n_x);ds_list_destroy(n_y);ds_list_destroy(n_z);
    ds_list_destroy(u);ds_list_destroy(v);
    }
    
if(string_count(".asc",argument1)>0) 
    {
    var str,file,row,tex_y,v_x,v_y,v_z,i,numb,edges,faces,t,p_count;
    file=file_text_open_read(argument1);
    v_x=ds_list_create();
    v_y=ds_list_create();
    v_z=ds_list_create();    
    row=""
    
    do
        {
        if(string_count("Vertex list:",row)=0)
            {
            do {row=file_text_read_string(file);file_text_readln(file)}
            until string_count("Vertex list:",row)=1
            }
        
        do
            {
            row=file_text_read_string(file);file_text_readln(file)
            if(string_count("Face list:",row)=0)
                {
                row=string_delete(row,1,string_pos(":",row))
                row=string_delete(row,1,string_pos(":",row))
                row=string_replace_all(row," ","")
                row=string_replace_all(row,"Y","")
                row=string_replace_all(row,"Z","")
                row+=":"
                str=string_copy(row,1,string_pos(":",row)-1)
                row=string_delete(row,1,string_pos(":",row))
                ds_list_add(v_x,real(str))
                str=string_copy(row,1,string_pos(":",row)-1)
                row=string_delete(row,1,string_pos(":",row))
                ds_list_add(v_y,real(str))
                str=string_copy(row,1,string_pos(":",row)-1)
                row=string_delete(row,1,string_pos(":",row))
                ds_list_add(v_z,real(str))
                }
            }
        until string_count("Face list:",row)=1
        
        do
            {
            row2=file_text_read_string(file);file_text_readln(file)
            if(string_count("Face",row2)=1)
                {
                d3d_model_primitive_begin(argument0,pr_trianglelist)
                row=string_delete(row2,1,string_pos("A:",row2)+1)
                row=string_copy(row,1,string_pos("AB",row)-1)
                row=string_replace_all(row," ","")
                row=string_replace_all(row,"B","")
                row=string_replace_all(row,"C","")
                row+=":"
                
                str=string_copy(row,1,string_pos(":",row)-1)
                row=string_delete(row,1,string_pos(":",row))
                t=real(str)
                d3d_model_vertex(argument0,ds_list_find_value(v_x,t)*scale,ds_list_find_value(v_y,t)*scale,ds_list_find_value(v_z,t)*scale)modelload[0]+=1;
                str=string_copy(row,1,string_pos(":",row)-1)
                row=string_delete(row,1,string_pos(":",row))
                t=real(str)
                d3d_model_vertex(argument0,ds_list_find_value(v_x,t)*scale,ds_list_find_value(v_y,t)*scale,ds_list_find_value(v_z,t)*scale)modelload[0]+=1;
                str=string_copy(row,1,string_pos(":",row)-1)
                row=string_delete(row,1,string_pos(":",row))
                t=real(str)
                d3d_model_vertex(argument0,ds_list_find_value(v_x,t)*scale,ds_list_find_value(v_y,t)*scale,ds_list_find_value(v_z,t)*scale)modelload[0]+=1;
                d3d_model_primitive_end(argument0)
                }
            }
        until (string_count("Face",row2)=0&&string_count("Smoothing",row2)=0)||file_text_eof(file)
        
        while !(string_count("Vertex list:",row)=1||file_text_eof(file)){row=file_text_read_string(file);file_text_readln(file)}
        ds_list_clear(v_x);ds_list_clear(v_y);ds_list_clear(v_z);
        }
    until file_text_eof(file) 
    
    ds_list_destroy(v_x);ds_list_destroy(v_y);ds_list_destroy(v_z);
    file_text_close(file);
    }
modelload[1]=abs(current_time-cur_milisec);
#define dex_freeform_camera_movement
 {
   return -global.zdirection*speed/128
 }
#define dex_get_video_driver
return _video_driver();
#define dex_get_video_memory
return _video_mem()/1024/1024;
#define dex_get_zdirection
return global.zdirection;
#define dex_heightmap_create
 {
grid=32
screen_redraw();
mapt=load_heightmap(3);
x+=32;
roaddif=load_heightmap(1);
ds_grid_multiply_region(roaddif,0,0,32,32,1/256)
map=ds_grid_create(32,32);
for (xx=1;xx<31;xx+=1)
for (yy=1;yy<31;yy+=1)
{
ds_grid_set(map,xx,yy,mean(ds_grid_get(mapt,xx,yy),ds_grid_get(mapt,xx+1,yy),ds_grid_get(mapt,xx-1,yy),ds_grid_get(mapt,xx,yy+1),ds_grid_get(mapt,xx,yy-1)));
}
for (xx=1;xx<31;xx+=1)
{
ds_grid_set(map,xx,0,mean(ds_grid_get(mapt,xx,0),ds_grid_get(mapt,xx+1,0),ds_grid_get(mapt,xx-1,0),ds_grid_get(mapt,xx,1)))
}
for (xx=1;xx<31;xx+=1)
{
ds_grid_set(map,xx,31,mean(ds_grid_get(mapt,xx,31),ds_grid_get(mapt,xx+1,31),ds_grid_get(mapt,xx-1,31),ds_grid_get(mapt,xx,30)))
}
for (xx=1;xx<31;xx+=1)
{
ds_grid_set(map,31,xx,mean(ds_grid_get(mapt,31,xx),ds_grid_get(mapt,31,xx+1),ds_grid_get(mapt,31,xx-1),ds_grid_get(mapt,30,xx)))
}
for (xx=1;xx<31;xx+=1)
{
ds_grid_set(map,0,xx,mean(ds_grid_get(mapt,0,xx),ds_grid_get(mapt,0,xx+1),ds_grid_get(mapt,0,xx-1),ds_grid_get(mapt,1,xx)))
}
ds_grid_set(map,0,0,mean(ds_grid_get(map,1,0),ds_grid_get(map,0,1),ds_grid_get(map,0,0)));
ds_grid_set(map,31,0,mean(ds_grid_get(map,31,1),ds_grid_get(map,30,0),ds_grid_get(map,31,0)));
ds_grid_set(map,31,31,mean(ds_grid_get(map,31,31),ds_grid_get(map,31,30),ds_grid_get(map,30,31)));
ds_grid_set(map,0,31,mean(ds_grid_get(map,1,30),ds_grid_get(map,1,30),ds_grid_get(map,1,30)));
ter_model=model_heightmap(map,0,.25);
mdif=ds_grid_create(32,32);
maxx=-1000;
for (xx=1;xx<31;xx+=1)
for (yy=1;yy<31;yy+=1)
{
ds_grid_set(mdif,xx,yy,max(abs(ds_grid_get(mapt,xx,yy)-ds_grid_get(mapt,xx-1,yy)),abs(ds_grid_get(mapt,xx,yy)-ds_grid_get(mapt,xx+1,yy)),abs(ds_grid_get(mapt,xx,yy)-ds_grid_get(mapt,xx,yy-1)),abs(ds_grid_get(mapt,xx,yy)-ds_grid_get(mapt,xx,yy+1))));
maxx=max(ds_grid_get(mdif,xx,yy),maxx);
}
ds_grid_multiply_region(mdif,0,0,32,32,.02);
for (xx=0;xx<32;xx+=1)
for (yy=0;yy<32;yy+=1)
{
alph=ds_grid_get(mdif,xx,yy);
if alph>.5 alph=1;
else alph=0;
ds_grid_set(mdif,xx,yy,alph);
}
mapp=ds_grid_create(32,32);
for (xx=1;xx<31;xx+=1)
for (yy=1;yy<31;yy+=1)
{
ds_grid_set(mapp,xx,yy,(ds_grid_get(roaddif,xx,yy)*8+ds_grid_get(roaddif,xx+1,yy)*2+ds_grid_get(roaddif,xx-1,yy)*2+ds_grid_get(roaddif,xx,yy+1)*2+ds_grid_get(roaddif,xx,yy-1)*2+ds_grid_get(roaddif,xx-1,yy-1)+ds_grid_get(roaddif,xx+1,yy-1)+ds_grid_get(roaddif,xx+1,yy+1)+ds_grid_get(roaddif,xx-1,yy+1))/20);
}
model_heightmapalpha(map,mdif,ter_model,.25,.5,1);
model_heightmapalpha(map,mapp,ter_model,.5,.75,2);
ds_grid_destroy(mapt);
ds_grid_destroy(mdif);
ds_grid_destroy(roaddif);
global.tex=background_get_texture(argument0);
global.grid=grid;
global.map=map;
global.height=true;
 }
#define dex_heightmap_draw
 {
   if global.height=true
   {
   d3d_model_draw(ter_model,0,0,-300,global.tex);
   }
 }
#define dex_heightmap_findheight
 {
  if global.height=true
   {
   gridx=floor(argument0/global.grid)
   gridy=floor(argument1/global.grid)
   offsetx= argument0-global.grid*gridx
   offsety= argument1-global.grid*gridy
   z1=ds_grid_get(global.map,gridx,gridy)
   z2=ds_grid_get(global.map,(gridx+1),gridy)
   z3=ds_grid_get(global.map,(gridx+1),(gridy+1))
   z4=ds_grid_get(global.map,gridx,(gridy+1))
   if offsetx>offsety then z__z=z1-offsetx*(z1-z2)/global.grid-offsety*(z2-z3)/global.grid
   else z__z=z1-offsetx*(z4-z3)/global.grid-offsety*(z1-z4)/global.grid
   return z__z;
   }
  else
   {
     return 0;
   }
 }
#define dex_init
{
  global.zdirection=0;
  global._zoom=0
  global.offset=0;
  global.colorshading=false;
  global.height=false;
  global._third=false;
  global.zspeed=0;
}
#define dex_light_enable
 {
    d3d_light_enable(argument0,argument1);
 }
#define dex_light_point
 {
   d3d_light_define_point(arguument0,x,y,argument1,argument2,argument3);
 }
#define dex_light_sun
 {
    d3d_light_define_direction(argument0,.25,-.5,-.5,argument1);
 }
#define dex_model_begin
 {
   d3d_model_primitive_begin(argument0,argument1);
 }
#define dex_model_block
 {
   d3d_model_block(argument0,argument1,argument2,argument3,argument4,argument5,argument6,1,1);
 }
#define dex_model_clear
 {
   d3d_model_clear(argument0);
 }
#define dex_model_cone
 {
   d3d_model_cone(argument0,argument1,argument2,argument3,argument4,argument5,argument6,1,1,true,50);
 }
#define dex_model_create
 {
   argument0=d3d_model_create();
 }
#define dex_model_cylinder
 {
   d3d_model_cylinder(argument0,argument1,argument2,argument3,argument4,argument5,argument6,1,1,true,50);
 }
#define dex_model_destroy
 {
   d3d_model_destroy(argument0);
 }
#define dex_model_draw
 {
   d3d_model_draw(argument0,argument1,argument2,argument3,sprite_get_texture(argument4,argument5));
 }
#define dex_model_ellipsoid
 {
   d3d_model_ellipsoid(argument0,argument1,argument2,argument3,argument4,argument5,argument6,1,1,50);
 }
#define dex_model_end
 {
   d3d_model_primitive_end(argument0);
 }
#define dex_model_floor
 {
   d3d_model_floor(argument0,argument1,argument2,argument3,argument4,argument5,argument6,1,1);
 }
#define dex_model_load
 {
   d3d_model_load(argument0,argument1);
 }
#define dex_model_save
 {
   d3d_model_save(argument0,argument1);
 }
#define dex_model_vertex
 {
   d3d_model_vertex(argument0,argument1,argument2,argument3);
 }
#define dex_model_vertex_normal
 {
   d3d_model_vertex_normal(argument0,argument1,argument2,argument3,argument1,argument2,argument3);
 }
#define dex_model_vertex_normal_color
 {
   d3d_model_vertex_normal_color(argument0,argument1,argument2,argument3,argument1,argument2,argument3,argument4,argument5);
 }
#define dex_model_vertex_normal_texture
 {
   d3d_model_vertex_normal_texture(argument0,argument1,argument2,argument3,argument1,argument2,argument3,argument4,argument5);
 }
#define dex_model_vertex_normal_texture_color
 {
   d3d_model_vertex_normal_texture_color(argument0,argument1,argument2,argument3,argument1,argument2,argument3,argument4,argument5,argument6,argument7);
 }
#define dex_model_vertex_texture
 {
   d3d_model_vertex_texture(argument0,argument1,argument2,argument3,argument4,argument5);
 }
#define dex_model_vertex_texture_color
 {
   d3d_model_vertex_texture_color(argument0,argument1,argument2,argument3,argument4,argument5,argument6,argument7);
 }
#define dex_mouselook
 {
   dispw=display_get_width()/2;
   disph=display_get_height()/2;
   changex=display_mouse_get_x()-dispw;
   changey=display_mouse_get_y()-disph;
   if global._third=false
    {
      direction-=changex/16;
    }
   if global._third=true
    {
      global._objectthird.direction-=changex/16;
    }
   global.zdirection+=changey/12;
   if global.zdirection<-89 then
    {
      global.zdirection=-89;
    } 
  else
   if global.zdirection>89 then
    {
       global.zdirection=89;
    }
   display_mouse_set(dispw,disph);
 }
#define dex_pause
 {
   d3d_set_projection_ortho(0,0,view_wview,view_hview,0);
   draw_set_color(argument1);
   draw_set_halign(fa_center);
   draw_text(view_wview/2,view_hview/2,argument0);
   screen_refresh();
   keyboard_wait();
   draw_set_color(c_white);
   io_clear();
 }
#define dex_projection_firstperson
 {
   x1=x;
   y1=y;
   z1=argument0;
   x2=x1+cos(degtorad(direction));
   y2=y1-sin(degtorad(direction));
   z2=z1-tan(degtorad(global.zdirection));
   d3d_set_projection(x1,y1,z1,x2,y2,z2,0,0,1);
 }
#define dex_projection_custom
 {
   x1=argument0;
   y1=argument1;
   z1=argument2;
   x2=argument3;
   y2=argument4;
   z2=argument5;
   d3d_set_projection(x1,y1,z1,x2,y2,z2,0,0,1);
 }
#define dex_projection_move_down
 {
   speed-=argument0
   if abs(speed)>-10 then speed*=.98;
 }
#define dex_projection_move_up
 {
   speed+=argument0
   if abs(speed)>10 then speed*=.98;
 }
#define dex_projection_rotate_down
 {
   global.zdirection-=argument0
 }
#define dex_projection_rotate_left
 {
   direction+=argument0
 }
#define dex_projection_rotate_right
 {
   direction-=argument0
 }
#define dex_projection_rotate_up
 {
   global.zdirection+=argument0
 }
#define dex_projection_thirdperson
 {
   if global.zdirection<-50
   global.zdirection=-50
   _xf=argument0.x+((-120+global._zoom)*cos(degtorad(argument0.direction)))
   _yf=argument0.y-((-120+global._zoom)*sin(degtorad(argument0.direction)))
   _zf=argument1+54+global.zdirection
   _xt=argument0.x
   _yt=argument0.y
   _zt=argument1+32
   if global.height=true
    {
      if _zf<dex_heightmap_findheight(_xf,_yf)-300+20
       {
         _zf=dex_heightmap_findheight(_xf,_yf)-300+20
       }
    }
   x=_xf
   y=_yf
   d3d_set_projection(_xf,_yf,_zf,_xt,_yt,_zt,0,0,1);
   global._objectthird=argument0
   global._third=true
 }
#define dex_projection_thirdperson_zoom_in
 {
   if global._third=true
    {
      if global._zoom<52
      global._zoom+=argument0
    }
 }
#define dex_projection_thirdperson_zoom_out
 {
   if global._third=true
    {
      if global._zoom>-16
      global._zoom-=argument0
    }
 }
#define dex_set_lighting
 {
   d3d_set_fog(argument0,argument1,argument2,argument3);
 }
#define dex_set_zdirection
global.zdirection=argument0;
#define dex_start
{
  d3d_start();
  d3d_set_lighting(argument0);
  d3d_set_hidden(argument1);
  d3d_set_perspective(argument2);
  draw_set_color(c_white);
  d3d_set_fog(argument3,argument4,argument5,argument6);
  d3d_set_culling(argument7);
  d3d_set_shading(argument8);
  texture_set_blending(true);
  texture_set_interpolation(true);
  background_color=c_black;
}
#define dex_trans_add_rotation_axis
 {
   d3d_transform_add_rotation_axis(argument0,argument1,argument2,argument3);
 }
#define dex_trans_add_rotation_x
 {
   d3d_transform_add_rotation_x(argument0);
 }
#define dex_trans_add_rotation_y
 {
   d3d_transform_add_rotation_y(argument0);
 }
#define dex_trans_add_rotation_z
 {
   d3d_transform_add_rotation_z(argument0);
 }
#define dex_trans_add_scaling
 {
   d3d_transform_add_scaling(argument0,argument1,argument2);
 }
#define dex_trans_add_translation
 {
   d3d_transform_add_translation(argument0,argument1,argument2);
 }
#define dex_trans_set_identity
 {
   d3d_transform_set_identity();
 }
#define dex_trans_set_rotation_axis
 {
   d3d_transform_set_rotation_axis(argument0,argument1,argument2,argument3);
 }
#define dex_trans_set_rotation_x
 {
   d3d_transform_set_rotation_x(argument0);
 }
#define dex_trans_set_rotation_y
 {
   d3d_transform_set_rotation_y(argument0);
 }
#define dex_trans_set_rotation_z
 {
   d3d_transform_set_rotation_z(argument0);
 }
#define dex_trans_set_scaling
 {
   d3d_transform_set_scaling(argument0,argument1,argument2);
 }
#define dex_trans_set_translation
 {
   d3d_transform_set_translation(argument0,argument1,argument2);
 }
#define dex_tree_draw
 {
   d3d_draw_cone(x-16,y-16,argument0,x+2,y+2,argument0+argument1,sprite_get_texture(argument2,0),3,argument0+argument1/64,false,32);
   d3d_draw_ellipsoid(x-9-64,y-9-64,argument0+argument1/2,x-9+64,y-9+64,argument0+argument1+64,sprite_get_texture(argument3,0),3,3,32);
 }
#define load_heightmap
 {
   temp=ds_grid_create(32,32);
   for (yp=0; yp<32; yp+=1)    
    {
     for (xp=0; xp<32; xp+=1)    
      {
        col=draw_getpixel(xp+x,yp+y);
        use=color_get_blue(col);        
        ds_grid_set(temp,xp,yp,use*argument0);
      }
    }
    return temp;   
 }
#define model_heightmap
 {
   a=0;
   temp=d3d_model_create();
   for(xx=0;xx<31;xx+=1)
    {
      for(yy=0;yy<31;yy+=1)
       {
         z1 = ds_grid_get(argument0,xx,yy);
         z2 = ds_grid_get(argument0,xx+1,yy);
         z3 = ds_grid_get(argument0,xx+1,yy+1);
         z4 = ds_grid_get(argument0,xx,yy+1);
         rx = point_direction(0,z1,grid,z2);
         ry = point_direction(0,z1,grid,z4);
         nx = lengthdir_x(1,rx);
         ny = lengthdir_x(1,ry);
         nz = 1;
         a=!a;
         d3d_model_primitive_begin(temp,pr_trianglefan);
         d3d_model_vertex_normal_texture(temp,xx*grid,yy*grid,ds_grid_get(argument0,xx,yy),nx,ny,nz,argument1,0);
         d3d_model_vertex_normal_texture(temp,(xx+1)*grid,yy*grid,ds_grid_get(argument0,xx+1,yy),nx,ny,nz,argument2,0);
         d3d_model_vertex_normal_texture(temp,(xx+1)*grid,(yy+1)*grid,ds_grid_get(argument0,xx+1,yy+1),nx,ny,nz,argument2,1);
         d3d_model_vertex_normal_texture(temp,xx*grid,(yy+1)*grid,ds_grid_get(argument0,xx,yy+1),nx,ny,nz,argument1,1);
         d3d_model_primitive_end(temp);
       }
    }
  return temp;
 }
#define model_heightmapalpha
 {
   if argument2==-1 temp=d3d_model_create();
   else temp=argument2;
   for(xx=0;xx<31;xx+=1) 
   {
     for(yy=0;yy<31;yy+=1)
      {
        z1 = ds_grid_get(argument0,xx,yy);
        z2 = ds_grid_get(argument0,xx+1,yy);
        z3 = ds_grid_get(argument0,xx+1,yy+1);
        z4 = ds_grid_get(argument0,xx,yy+1);
        rx = point_direction(0,z1,grid,z2);
        ry = point_direction(0,z1,grid,z4);
        nx = lengthdir_x(1,rx);
        ny = lengthdir_x(1,ry);
        nz = 1;
        if ds_grid_get(argument1,xx,yy)>=1 && ds_grid_get(argument1,xx+1,yy)>=1 && ds_grid_get(argument1,xx+1,yy+1)>=1 && ds_grid_get(argument1,xx,yy+1)>=1
         {
           d3d_model_primitive_begin(temp,pr_trianglefan);
           d3d_model_vertex_normal_texture(temp,xx*grid,yy*grid,ds_grid_get(argument0,xx,yy)+argument5,nx,ny,nz,argument3,0);
           d3d_model_vertex_normal_texture(temp,(xx+1)*grid,yy*grid,ds_grid_get(argument0,xx+1,yy)+argument5,nx,ny,nz,argument4,0);
           d3d_model_vertex_normal_texture(temp,(xx+1)*grid,(yy+1)*grid,ds_grid_get(argument0,xx+1,yy+1)+argument5,nx,ny,nz,argument4,1);
           d3d_model_vertex_normal_texture(temp,xx*grid,(yy+1)*grid,ds_grid_get(argument0,xx,yy+1)+argument5,nx,ny,nz,argument3,1);
           d3d_model_primitive_end(temp);
         }
        else if ds_grid_get(argument1,xx,yy)>=.0000001 || ds_grid_get(argument1,xx+1,yy)>=.0000001 || ds_grid_get(argument1,xx+1,yy+1)>=.0000001 || ds_grid_get(argument1,xx,yy+1)>=.0000001
         {
           d3d_model_primitive_begin(temp,pr_trianglefan);
           d3d_model_vertex_normal_texture_color(temp,xx*grid,yy*grid,ds_grid_get(argument0,xx,yy)+argument5,nx,ny,nz,argument3,0,c_white,ds_grid_get(argument1,xx,yy));
           d3d_model_vertex_normal_texture_color(temp,(xx+1)*grid,yy*grid,ds_grid_get(argument0,xx+1,yy)+argument5,nx,ny,nz,argument4,0,c_white,ds_grid_get(argument1,xx+1,yy));
           d3d_model_vertex_normal_texture_color(temp,(xx+1)*grid,(yy+1)*grid,ds_grid_get(argument0,xx+1,yy+1)+argument5,nx,ny,nz,argument4,1,c_white,ds_grid_get(argument1,xx+1,yy+1));
           d3d_model_vertex_normal_texture_color(temp,xx*grid,(yy+1)*grid,ds_grid_get(argument0,xx,yy+1)+argument5,nx,ny,nz,argument3,1,c_white,ds_grid_get(argument1,xx,yy+1));
           d3d_model_primitive_end(temp);
         }
      }
   }
  return temp;
 }
